/*

Read Route Record

Copyright (C) 2018-2020 Atle Solbakken atle@goliathdns.no

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.

*/

#ifndef RRR_IP_DEFINES_H
#define RRR_IP_DEFINES_H

#define RRR_IP_RECEIVE_OK 0
#define RRR_IP_RECEIVE_ERR 1
#define RRR_IP_RECEIVE_STOP 2

#define RRR_IP_RECEIVE_MAX_STEP_SIZE 8096

#define RRR_IP_AUTO	0
#define RRR_IP_UDP	1
#define RRR_IP_TCP	2

#define RRR_IP_TRANSPORT_NAME(type) \
	(type == RRR_IP_AUTO ? "auto" : \
	(type == RRR_IP_UDP ? "udp" : \
	(type == RRR_IP_TCP ? "tcp" : \
	"(unknown)")))

#endif /* RRR_IP_DEFINES_H */
